<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,minimum-scale=1,minimal-ui,viewport-fit=cover,user-scalable=0">
  <title>SRT LAB BD</title>

  <!-- Fonts & Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    :root{
      --primary:linear-gradient(135deg,#ff4da6,#ffd700);
      --primary-dark:#ff4da6;
      --bg:linear-gradient(135deg,#f9f9ff,#f4f2ff);
      --white:#fff;
      --shadow:0 6px 18px rgba(255,77,166,.25),0 0 15px #214ebe;
    }
    *{margin:0;padding:0;box-sizing:border-box;-webkit-tap-highlight-color:transparent;user-select:none}
    body{font-family:'Hind Siliguri',sans-serif;background:var(--bg);color:#333;padding-bottom:160px}

    .container{padding:15px}

    /* Header */
    .header{
      background:var(--primary);
      padding:15px;text-align:center;
      box-shadow:0 6px 20px rgba(255,77,166,.35),0 0 20px #ffd700;
      border-bottom-left-radius:16px;
      border-bottom-right-radius:16px;
    }
    .header h5{color:#fff;font-size:22px;font-weight:800;margin:0}

    /* Tabs */
    .tab-container{
      display:flex;background:#;border-radius:14px;padding:5px;margin:20px auto;width:92%;
      )
    }
    .tab{
      flex:1;padding:12px 0;text-align:center;font-weight:700;font-size:15px;
      color:#fff;border-radius:12px;cursor:pointer;transition:.3s
    }
    .tab.active{
      background: #214ebe;

    }
    .tab-content{display:none}
    .tab-content.active{display:block}

    /* Package Card */
    .income-card{
      background:var(--white);border-radius:18px;
      box-shadow:var(--shadow);
      margin-bottom:22px;overflow:hidden;transition:.3s
    }
    .income-card:hover{transform:translateY(-4px)}
    .card-top{display:flex;gap:15px;padding:15px}
    .card-image{width:100px;height:100px;border-radius:12px;object-fit:cover;flex-shrink:0;box-shadow:0 4px 12px rgba(0,0,0,.1)}
    .card-details h3{font-size:18px;font-weight:800;margin-bottom:6px;color:#333}
    .card-price{font-size:14px;color:#555;margin-bottom:8px}
    .card-stats{display:flex;justify-content:space-between;gap:10px}
    .stat-item{text-align:left}
    .stat-label{font-size:12px;color:#888}
    .stat-value{
      font-size:15px;font-weight:800;
      background: #214ebe;
      -webkit-background-clip:text;-webkit-text-fill-color:transparent
    }

    .card-bottom{
      padding:15px;display:flex;justify-content:space-between;align-items:center;
      border-top:1px solid #f0f0f0;background:#fafafa
    }
    .price-display{font-size:15px;font-weight:700;color:#333}
    
    .status-badge{
      background:#ddd;
      color:#666;
      padding:8px 18px;
      border-radius:20px;
      font-weight:700;
      font-size:13px;
    }

    /* Progressive Earning Display */
    .earning-progress{
      padding:12px 15px;
      background:linear-gradient(135deg,#f0f9ff,#fef3c7);
      border-top:1px solid #e5e7eb;
      display:flex;
      justify-content:space-between;
      align-items:center;
    }
    .progress-info{
      display:flex;
      flex-direction:column;
      gap:4px;
    }
    .progress-label{
      font-size:11px;
      color:#666;
      font-weight:600;
    }
    .progress-amount{
      font-size:16px;
      font-weight:800;
      background:var(--primary);
      -webkit-background-clip:text;
      -webkit-text-fill-color:transparent;
    }
    .progress-bar-container{
      flex:1;
      margin:0 15px;
      height:8px;
      background:#e5e7eb;
      border-radius:10px;
      overflow:hidden;
    }
    .progress-bar{
      height:100%;
      background:var(--primary);
      transition:width .3s ease;
      border-radius:10px;
    }

    /* Fixed Bottom Claim Bar - White Soft Design */
    .claim-bar{
      position:fixed;
      bottom:70px;
      left:10px;
      right:10px;
      background:#fff;
      padding:14px 18px;
      border-radius:16px;
      display:none;
      align-items:center;
      justify-content:space-between;
      z-index:998;
      box-shadow:0 4px 20px rgba(255,77,166,.2),0 0 25px rgba(255,215,0,.15);
      border:1px solid rgba(255,215,0,.2);
      transition:all .4s ease;
    }
    .claim-bar.show{display:flex}
    .claim-bar.ready{
      box-shadow:0 0 30px rgba(255,215,0,.4),0 0 40px rgba(255,77,166,.3),0 4px 25px rgba(74,222,128,.2);
      border:2px solid rgba(255,215,0,.5);
      animation:softGlow 2s ease-in-out infinite;
    }
    @keyframes softGlow{
      0%,100%{box-shadow:0 0 30px rgba(255,215,0,.4),0 0 40px rgba(255,77,166,.3),0 4px 25px rgba(74,222,128,.2)}
      50%{box-shadow:0 0 40px rgba(255,215,0,.6),0 0 50px rgba(255,77,166,.4),0 6px 30px rgba(74,222,128,.3)}
    }

    .claim-info{
      display:flex;
      flex-direction:column;
      gap:3px;
    }
    .time-label{
      font-size:11px;
      font-weight:600;
      color:#888;
      text-transform:uppercase;
    }
    .time-value{
      font-size:18px;
      font-weight:800;
      letter-spacing:.5px;
      background:var(--primary);
      -webkit-background-clip:text;
      -webkit-text-fill-color:transparent;
    }
    .amount-label{
      font-size:12px;
      color:#666;
      font-weight:600;
      margin-top:2px;
    }

    .claim-btn{
      background:var(--primary);
      color:#fff;
      border:none;
      padding:12px 26px;
      border-radius:25px;
      font-weight:800;
      font-size:15px;
      cursor:pointer;
      transition:all .3s ease;
      box-shadow:0 4px 15px rgba(255,77,166,.3);
      position:relative;
      overflow:hidden;
    }
    .claim-btn::before{
      content:'';
      position:absolute;
      top:50%;left:50%;
      width:0;height:0;
      border-radius:50%;
      background:rgba(255,255,255,.3);
      transform:translate(-50%,-50%);
      transition:width .6s,height .6s;
    }
    .claim-btn:hover{
      transform:translateY(-2px);
      box-shadow:0 6px 20px rgba(255,77,166,.4),0 0 25px rgba(255,215,0,.3);
    }
    .claim-btn:hover::before{width:200px;height:200px}
    .claim-btn:active{transform:translateY(0)}
    .claim-btn:disabled{
      background:#ccc;
      color:#999;
      cursor:not-allowed;
      box-shadow:none;
    }

    /* Navbar with Center Fingerprint Button */
    .menubar{
      position:fixed;
      bottom:0;
      left:0;
      right:0;
      height:72px;
      background:#fff;
      display:flex;
      justify-content:space-around;
      align-items:center;
      box-shadow:0 -6px 16px rgba(0,0,0,.1);
      z-index:999;
      border-radius:16px 16px 0 0;
    }
    .nav-link{
      display:flex;
      flex-direction:column;
      align-items:center;
      font-size:13px;
      text-decoration:none;
      color:#777;
      font-weight:600;
      transition:.3s;
    }
    .nav-link i{
      font-size:22px;
      margin-bottom:4px;
    }
    .nav-link.active{color:#ff4da6}

    /* Center Floating Fingerprint Button */
    .center-btn{
      position:relative;
      top:-28px;
      width:78px;
      height:78px;
      background:linear-gradient(135deg,#ff4da6,#ffd700);
      border-radius:50%;
      display:flex;
      align-items:center;
      justify-content:center;
      box-shadow:0 0 20px rgba(255,215,0,.7),0 0 25px rgba(255,77,166,.45);
      border:5px solid #fff;
      cursor:pointer;
      transition:.3s;
    }
    .center-btn i{color:#fff;font-size:28px}
    .center-btn:hover{transform:scale(1.05)}

    @media(max-width:600px){
      .card-image{width:85px;height:85px}
      .card-details h3{font-size:16px}
      .time-value{font-size:16px}
      .claim-btn{padding:10px 22px;font-size:14px}
      .center-btn{width:70px;height:70px}
      .center-btn i{font-size:24px}
    }
  </style>
</head>
<body>
<div class="page-wraper">

  <!-- Header -->


  <?php
    use \App\Models\Package;
    $vipPlans = Package::where('Status','!=','inactive')->where('tab','vip')->get();
    $popularPlans = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
  ?>

  <div class="container">
    <!-- Tabs -->
    <div class="tab-container">
      <div class="tab active" data-tab="daily">My Order</div>

    </div>

    <!-- VIP Plans -->
    <div id="daily" class="tab-content active">
      <?php $__currentLoopData = $vipPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $myVip = \App\Models\Purchase::where('user_id',auth()->id())->where('package_id',$element->id)->where('status','active')->first();
          $last_claim = \App\Models\UserLedger::where(['user_id'=>auth()->id(),'reason'=>'daily_claim_'.$element->id])->latest()->first();
          $lastPurchaseDate = $last_claim->created_at ?? $myVip->created_at ?? null;
          $diffInHours = $lastPurchaseDate ? $lastPurchaseDate->diffInHours(now()) : 25;
        ?>
        <?php if($myVip): ?>
        <div class="income-card" data-package-id="<?php echo e($element->id); ?>" data-amount="<?php echo e($element->daily_limit); ?>">
          <div class="card-top">
            <img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="card-image">
            <div class="card-details">
              <h3><?php echo e($element->name); ?></h3>
              <p class="card-price">Price: <?php echo e(price($element->price)); ?></p>
              <div class="card-stats">
                <div class="stat-item"><div class="stat-label"> Daily Income</div><div class="stat-value"><?php echo e(price($element->daily_limit)); ?></div></div>
                <div class="stat-item"><div class="stat-label"> Total Income</div><div class="stat-value"><?php echo e(price($element->daily_limit * $element->validity)); ?></div></div>
              </div>
            </div>
          </div>
          


          <div class="card-bottom">
            <div class="price-display"><?php echo e($element->validity); ?> Days</div>
            <div class="status-badge" id="status-<?php echo e($element->id); ?>">Running</div>
          </div>
        </div>

        <script>
          (function(){
            const lastDate = <?php echo json_encode($lastPurchaseDate, 15, 512) ?>;
            const diff = <?php echo json_encode($diffInHours, 15, 512) ?>;
            const claimed = <?php echo e(App\Models\UserLedger::where(['user_id'=>auth()->id(),'reason'=>'daily_claim_'.$element->id])->whereDate('created_at',today())->exists() ? 'true' : 'false'); ?>;
            const statusBtn=document.getElementById("status-<?php echo e($element->id); ?>");
            const packageId = "<?php echo e($element->id); ?>";
            const dailyAmount = parseFloat("<?php echo e($element->daily_limit); ?>");
            const progressBar = document.getElementById("progress-<?php echo e($element->id); ?>");
            const earnedDisplay = document.getElementById("earned-<?php echo e($element->id); ?>");
            const progressBarFill = document.getElementById("progressbar-<?php echo e($element->id); ?>");
            
            // Progressive earning: 24 hours = 1440 minutes, earn every 5 minutes = 288 intervals
            const totalMinutes = 1440; // 24 hours
            const intervalMinutes = 5; // Every 5 minutes
            const totalIntervals = totalMinutes / intervalMinutes; // 288 intervals
            const amountPerInterval = dailyAmount / totalIntervals; // Amount per 5 min

            if(diff<24){
              statusBtn.style.display='block';
              statusBtn.innerText='Running';
              statusBtn.style.background='#214ebe';
              statusBtn.style.color='#fff';
              progressBar.style.display='flex';
              
              let start=new Date(lastDate);
              let end=new Date(start.getTime()+24*60*60*1000);
              
              function pad(n){return n<10?'0'+n:n;}
              
              window.claimData = window.claimData || {};
              window.claimData[packageId] = {
                endTime: end,
                amount: dailyAmount.toFixed(2),
                ready: false,
                claimed: false
              };

              function updateProgress(){
                let now=new Date().getTime();
                let elapsed = now - start.getTime();
                let totalDuration = 24*60*60*1000;
                let d=end-now;
                
                // Calculate progressive earning
                let minutesElapsed = Math.floor(elapsed / (60*1000));
                let intervalsCompleted = Math.floor(minutesElapsed / intervalMinutes);
                let earnedSoFar = Math.min(intervalsCompleted * amountPerInterval, dailyAmount);
                let progressPercent = (earnedSoFar / dailyAmount) * 100;
                
                // Update progress display
                earnedDisplay.innerText = '৳ ' + earnedSoFar.toFixed(2);
                progressBarFill.style.width = progressPercent + '%';
                
                if(d<=0){
                  clearInterval(timer);
                  statusBtn.style.background='#4ade80';
                  statusBtn.style.color='#fff';
                  statusBtn.innerText='প্রস্তুত';
                  earnedDisplay.innerText = '৳ ' + dailyAmount.toFixed(2);
                  progressBarFill.style.width = '100%';
                  window.claimData[packageId].ready = true;
                  window.updateClaimBar();
                  return;
                }
                window.updateClaimBar();
              }
              
              let timer=setInterval(updateProgress, 1000);
              updateProgress();
            }else{
              window.claimData = window.claimData || {};
              if(claimed){
                statusBtn.style.display='block';
                statusBtn.innerText='সম্পন্ন';
                statusBtn.style.background='#ddd';
                statusBtn.style.color='#666';
                window.claimData[packageId] = {ready: false, claimed: true, amount: dailyAmount.toFixed(2)};
              }
              else{
                statusBtn.style.display='block';
                statusBtn.style.background='#4ade80';
                statusBtn.style.color='#fff';
                statusBtn.innerText='প্রস্তুত';
                progressBar.style.display='flex';
                earnedDisplay.innerText = '৳ ' + dailyAmount.toFixed(2);
                progressBarFill.style.width = '100%';
                window.claimData[packageId] = {ready: true, claimed: false, amount: dailyAmount.toFixed(2)};
                window.updateClaimBar();
              }
            }
          })();
        </script>
        <?php endif; ?>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Popular Plans -->
    <div id="popular" class="tab-content">
      <?php $__currentLoopData = $popularPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $myVip = \App\Models\Purchase::where('user_id',auth()->id())->where('package_id',$element->id)->where('status','active')->first();
        ?>
        <?php if($myVip): ?>
        <div class="income-card">
          <div class="card-top">
            <img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="card-image">
            <div class="card-details">
              <h3><?php echo e($element->name); ?></h3>
              <p class="card-price">মূল্য: <?php echo e(price($element->price)); ?></p>
              <div class="card-stats">
                <div class="stat-item"><div class="stat-label">দৈনিক আয়</div><div class="stat-value"><?php echo e(price($element->daily_limit)); ?></div></div>
                <div class="stat-item"><div class="stat-label">মোট আয়</div><div class="stat-value"><?php echo e(price($element->daily_limit * $element->validity)); ?></div></div>
              </div>
            </div>
          </div>
          <div class="card-bottom">
            <div class="price-display"><?php echo e($element->validity); ?> দিন</div>
            <?php if($myVip->created_at->addDays($element->validity) <= now()): ?>
              <div class="status-badge" style="background:#4ade80;color:#fff">প্রস্তুত</div>
            <?php else: ?>
              <div class="status-badge">R</div>
            <?php endif; ?>
          </div>
        </div>
        <?php endif; ?>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>

 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item active" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>


<script>
  // Tab Switching
  document.querySelectorAll('.tab').forEach(tab=>{
    tab.addEventListener('click',function(){
      document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
      document.querySelectorAll('.tab-content').forEach(c=>c.classList.remove('active'));
      this.classList.add('active');
      document.getElementById(this.dataset.tab).classList.add('active');
      window.updateClaimBar();
    });
  });

  // Update Claim Bar
  window.claimData = window.claimData || {};
  let activePackageId = null;

  window.updateClaimBar = function(){
    const claimBar = document.getElementById('claimBar');
    const claimTime = document.getElementById('claimTime');
    const claimAmount = document.getElementById('claimAmount');
    const claimBtn = document.getElementById('claimBtn');
    
    let hasActive = false;
    let isReady = false;
    
    for(let pkgId in window.claimData){
      const data = window.claimData[pkgId];
      if(data.claimed) continue;
      
      if(data.ready){
        hasActive = true;
        isReady = true;
        activePackageId = pkgId;
        claimTime.innerText = 'প্রস্তুত';
        claimAmount.innerText = 'amount ৳ ' + data.amount;
        break;
      }
      else if(data.endTime){
        hasActive = true;
        activePackageId = pkgId;
        
        let now = new Date().getTime();
        let d = data.endTime - now;
        if(d > 0){
          function pad(n){return n<10?'0'+n:n;}
          let h=Math.floor((d%(1000*60*60*24))/(1000*60*60));
          let m=Math.floor((d%(1000*60*60))/(1000*60));
          let s=Math.floor((d%(1000*60))/1000);
          claimTime.innerText = `${pad(h)}ঘ ${pad(m)}মি ${pad(s)}সে`;
          claimAmount.innerText = 'amount ৳ ' + data.amount;
        }
      }
    }
    
    if(hasActive){
      claimBar.classList.add('show');
      if(isReady){
        claimBar.classList.add('ready');
        claimBtn.disabled = false;
      }else{
        claimBar.classList.remove('ready');
        claimBtn.disabled = true;
      }
    }else{
      claimBar.classList.remove('show');
    }
  }

  // Handle Claim Click
  function handleClaim(){
    if(activePackageId){
      window.location.href = '/my/vip?vip_id=' + activePackageId;
    }
  }

  // Update every second
  setInterval(window.updateClaimBar, 1000);
  window.updateClaimBar();
</script>
</body>
</html><?php /**PATH /home/nexivo2437/public_html/resources/views/app/main/myvip.blade.php ENDPATH**/ ?>