<!DOCTYPE html>
<html lang="bn">
<head>
    
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
	
	<title>SRT LAB BD</title>

    <link rel="shortcut icon" type="image/x-icon" href="/IMG_20250918_172903_494.jpg">
	
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

</head>    
<body data-theme-color="color-blue-soft-ui">
<div class="page-wraper">

<style>
/* --- 🎨 Refined Color Palette: Dark Blue & Pure White --- */
:root {
    --theme-primary: #214ebe; /* Mukhya Rang: Dark Blue */
    --theme-header: #214ebe; /* Header Rang: Slightly Darker Blue */
    --theme-gradient: linear-gradient(135deg, #3a68d7, #214ebe); 
    --text-light: #ffffff;
    --text-dark: #333333;
    --background-color: #F8F9FA; /* Off-White Background */
    --card-bg: #FFFFFF; /* Pure White Card Background */
    --card-shadow: 0 10px 40px rgba(0, 0, 0, 0.1); /* Floating Card Shadow */
    --input-shadow: 0 2px 8px rgba(0, 0, 0, 0.05); /* Subtle Input Shadow */
    --amount-btn-bg: #F0F5FF; /* Very Light Blue for buttons */
    --amount-btn-border: #BBDEFB;
}
/* --- Reset and Base Styles --- */
* { margin: 0; padding: 0; box-sizing: border-box; }
body {
    background-color: var(--background-color);
    font-family: 'Poppins', sans-serif;
    font-weight: 500;
}
.container {
    padding: 0 15px;
}
/* --- 1. Header Section (Header Blue - Aladā) --- */
.header {
    background: var(--theme-header); 
    padding: 15px;
    color: var(--text-light);
    text-align: center;
}
.header h5 {
    font-weight: 700;
    margin: 0;
    color: var(--text-light);
    font-size: 20px;
}
/* --- Curved Top Section (Blue Background) --- */
.curved-top-section {
    background: #96b4ff; 
    /* Dē'ōẏāla thēkē alādā karāra jan'ya ekhana nīcē śyāḍō byabāhāra kōrā haẏa ni */
    border-bottom-left-radius: 60px; /* Āro bēśi gōlākār */
    border-bottom-right-radius: 60px;
    padding-bottom: 80px; /* Bēlēnca bōksaṭi nīcē nāmātē bēśi padding */
}
/* --- 2. Balance Box (Śādā, Card Style) --- */
.balance-box {
    width: 90%;
    max-width: 300px;
    margin: 0 auto;
    background: var(--card-bg); /* Pure White */
    border-radius: 20px; /* Āro bēśi gōlākār */
    display: flex;
    justify-content: center;
    align-items: center;
    text-align: center;
    padding: 15px; /* Size ṭhik rākhā hala */
    box-shadow: 0 10px 30px rgba(33, 78, 190, 0.2); /* Elevated Blue Shadow */
    color: var(--text-dark);
    /* Float up from the blue section */
    position: relative; 
    top: -60px; /* Upare tōlā hala */
}
.balance-box p {
    margin: 0;
    font-size: 28px; /* Slightly larger amount */
    font-weight: 700;
    color: var(--theme-primary); 
}
.balance-box span {
    font-size: 14px; 
    font-weight: 500;
    color: #888;
    display: block;
}
/* --- Form and Input Styles (New Card Look) --- */
.form-container {
    background: var(--card-bg); /* White */
    border-radius: 18px;
    padding: 25px; /* More padding */
    margin: 0 15px;
    margin-top: -45px; /* Overlap with curved section */
    position: relative;
    box-shadow: var(--card-shadow); /* Stronger Card Shadow */
}
.form-control {
    height: 55px; 
    font-size: 20px;
    font-weight: 700;
    border-radius: 12px; /* Softer corners for inputs */
    border: 1px solid #ddd; 
    text-align: center;
    width: 100%;
    transition: all 0.3s ease;
    box-shadow: var(--input-shadow); /* Subtle shadow for depth */
}
.form-control:focus {
    border-color: var(--theme-primary); 
    box-shadow: 0 0 0 4px rgba(33, 78, 190, 0.2), var(--input-shadow); 
    outline: none;
}
.form-label {
    color: var(--text-dark);
    font-weight: 600;
    margin-bottom: 8px;
    display: block;
    font-size: 15px;
}
/* --- 3. Amount Grid (6 Buttons) --- */
h5 {
    color: var(--theme-primary); 
    margin-top:20px; 
    margin-bottom: 12px; 
    font-weight: 600;
    font-size: 16px;
}
.amount-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 12px; 
    margin-top: 15px;
}
.amount-btn {
    background: var(--amount-btn-bg); 
    color: var(--theme-primary);
    font-weight: 600;
    border-radius: 10px; /* Softer button corners */
    padding: 14px 10px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    border: none; /* Removed border for soft look */
    box-shadow: 0 2px 5px rgba(33, 78, 190, 0.1);
    font-size: 15px;
}
.amount-btn.active, .amount-btn:hover {
    background: var(--theme-gradient); 
    color: var(--text-light);
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(33, 78, 190, 0.4); 
}

/* --- Recharge Button (Main CTA - Dark Blue) --- */
.recharge-btn {
    padding: 18px; /* Slightly taller */
    font-size: 19px; /* Slightly larger font */
    font-weight: 700;
    width: 100%;
    margin-top: 35px; /* More spacing */
    border-radius: 50px;
    background: var(--theme-gradient); 
    color: var(--text-light);
    border: none;
    box-shadow: 0px 10px 30px rgba(33, 78, 190, 0.6); /* Stronger shadow for CTA */
    transition: all 0.3s ease;
    letter-spacing: 1px;
}
.recharge-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0px 12px 40px rgba(33, 78, 190, 0.8);
}

/* --- Info Section (Separate Card) --- */
.info-section {
    margin: 15px;
    margin-top: 25px;
    background: var(--card-bg);
    border-radius: 18px; /* Matched Card Border */
    padding: 20px;
    color: #555;
    font-size: 13px;
    font-weight: 500;
    box-shadow: var(--card-shadow);
    line-height: 1.8;
    border-left: 5px solid var(--theme-primary); 
}
.info-section b {
    color: var(--theme-primary); 
    font-weight: 700;
}

</style>

<header class="header">
    <h5>Recharge</h5>
</header>

<div class="page-content">
    <div class="content-inner pt-0">
        <div class="curved-top-section">
             <div class="container" style="padding-top: 15px;">
                </div>
        </div>

        <div class="balance-box">
            <div>
                <p>৳{{ number_format($totalDeposit, 2) }}</p>
                <span>Deposit Balance</span>
            </div>
        </div>

        <div class="form-container">
            <form id="topupForm" action="/home/create_topup_order" method="POST">
                <div class="form-group">
                    <label class="form-label">Enter Amount</label>
                    <input id="topupAmount" type="number" min="300" 
                        class="form-control"
                        name="amount" placeholder="Minimum 300 ৳">
                </div>
                
                <h5>Quick Amount</h5>
                <div class="amount-grid">
                    <div class="amount-btn" data-amount="300">৳300</div>
                    <div class="amount-btn" data-amount="800">৳800</div>
                    <div class="amount-btn" data-amount="1500">৳1500</div>
                    <div class="amount-btn" data-amount="3000">৳3000</div>
                    <div class="amount-btn" data-amount="5000">৳5000</div>
                    <div class="amount-btn" data-amount="10000">৳10000</div> 
                </div>

                <button type="button" onclick="goPayment()" class="recharge-btn" id="rechargeBtn">
                    <i class="fas fa-arrow-circle-right"></i> Recharge Now
                </button>
            </form>
        </div>

        <div class="info-section">
            <b>Recharge Policy:</b><br>
            1. Minimum deposit is <b>300 ৳</b>. Payment must be made according to the order amount.<br>
            2. After payment, the balance will be credited within 10 minutes.<br>
            3. If not credited within 30 minutes, contact Customer Service.
        </div>
    </div>
</div>
   <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item active" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // JS Logic (No change needed)
    $('.amount-btn').on('click', function() {
        $('.amount-btn').removeClass('active');
        $(this).addClass('active');
        
        const amount = $(this).data('amount');
        $('#topupAmount').val(amount);
    });

    $('#topupAmount').on('input', function() {
        $('.amount-btn').removeClass('active');
        const currentAmount = $(this).val();
        $(`.amount-btn[data-amount="${currentAmount}"]`).addClass('active');
    });

    function goPayment(){
        let amount = document.querySelector('#topupAmount').value;
        if (amount < 300) {
            alert('Minimum amount is 300 ৳');
            return;
        }
        // NOTE: The following lines are placeholders for PHP/Blade variables.
        let user_id = "{{auth()->user()->id}}"; 
        let number_url = '{{base64_encode(route('api_recharge'))}}';
        let response_url = '{{base64_encode(route('api_recharge_confirm'))}}';

        window.location.href = `/onepay?payment=${amount}&nurl=${number_url}&res_url=${response_url}&user_id=${user_id}`;
    }
</script>
</body>
</html>