<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>SRT LAB BD</title>

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        :root{
            /* Your Primary Theme Color */
            --primary-color: #214ebe; 
            --secondary-accent: #00c7a5; /* Green for gradient contrast */
            --primary-gradient: linear-gradient(135deg, var(--primary-color), var(--secondary-accent));
            --bg-light: #f0f2f5;
            --white:#fff;
            --text-dark: #222;
            --text-muted: #777;
            --shadow-card: 0 8px 25px rgba(33, 78, 190, 0.15);
            --shadow-btn: 0 8px 20px rgba(33, 78, 190, 0.5);
            --fail-color: #e74c3c;
        }
        *{margin:0;padding:0;box-sizing:border-box}
        body{
            font-family:'Poppins',sans-serif;
            background: var(--bg-light);
            padding-bottom: 20px;
        }

        /* Header */
        .header{
            background:var(--primary-color);
            padding:18px 15px;
            text-align:center;
            color:var(--white);
            font-weight:700;
            font-size:18px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            position: sticky; top: 0; z-index: 100;
        }

        /* Redeem Box */
        .redeem-container{padding:25px 15px;}
        .redeem-card{
            background:var(--white);
            border-radius:15px;
            padding:30px 25px;
            text-align:center;
            box-shadow:var(--shadow-card);
        }
        .redeem-icon{
            width:80px;height:80px;
            margin:0 auto 25px;
            background:var(--primary-gradient);
            border-radius:50%;
            display:flex;align-items:center;justify-content:center;
            color:var(--white);
            font-size:35px;
            box-shadow: var(--shadow-btn);
        }
        .code-input{
            width:100%;height:55px;
            border:2px solid #ddd;
            border-radius:10px;
            font-size:18px;
            text-align:center;
            margin-bottom:20px;
            font-weight:600;
            transition:.3s;
            color: var(--text-dark);
            padding: 0 10px;
        }
        .code-input:focus{
            border-color:var(--primary-color);
            outline:none;
            box-shadow:0 0 0 4px rgba(33, 78, 190, 0.15);
        }
        .redeem-btn{
            background:var(--primary-gradient);
            color:var(--white);
            border:none;border-radius:10px;
            height:55px;font-size:17px;
            font-weight:700;width:100%;
            cursor:pointer;
            box-shadow:var(--shadow-btn);
            transition:.3s;
        }
        .redeem-btn:hover{
            transform:translateY(-1px);
            opacity: 0.95;
        }
        .redeem-btn i { margin-right: 8px; }

        /* Info Text */
        .info-box{
            margin-top:30px;
            font-size:14px;line-height:1.6;
            color:var(--text-muted);
            background:var(--white);
            padding:20px;
            border-radius:15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            border-left: 4px solid var(--primary-color);
        }
        .info-box h3 {
            color: var(--primary-color);
            font-size: 16px;
            margin-bottom: 10px;
            font-weight: 700;
        }
        .info-box p {
            margin-bottom: 8px;
        }
        .info-box b{color:var(--primary-color)}

        /* Success/Fail Styling */
        #successOverlay{
            position:fixed;top:0;left:0;right:0;bottom:0;background:rgba(0,0,0,0.7);
            display:none;align-items:center;justify-content:center;z-index:9999;flex-direction:column;
        }
        #bonusAmount{
            font-size:0px;color:var(--white);font-weight:900;
            background:var(--primary-gradient);padding:20px 30px;border-radius:15px;
            box-shadow: var(--shadow-btn);
            animation:zoomIn 2s forwards;
        }
        @keyframes zoomIn{
            0%{font-size:0; opacity: 0}
            70%{font-size:40px; opacity: 1}
            100%{font-size:30px}
        }
        .fail-alert{
            background: #fff;
            color: var(--fail-color); 
            padding: 15px;
            font-weight: 600;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(231, 76, 60, 0.2);
            display: none;
            margin-top: 20px;
            border: 1px solid var(--fail-color);
        }
        .fail-alert i { margin-right: 5px; }
    </style>
</head>
<body>

    <div class="header"> Gift Code Bonus</div>

    <div class="redeem-container">
        <div class="redeem-card">
            <div class="redeem-icon"><i class="fas fa-gift"></i></div>
            <form id="bonusForm">
                <input type="text" class="code-input" name="bonus_code" placeholder="Enter your gift code" id="giftCode" required>
                <button class="redeem-btn" type="submit"><i class="fas fa-check-circle"></i> REDEEM CODE</button>
            </form>
            <div class="fail-alert" id="failAlert"><i class="fas fa-exclamation-circle"></i> Sorry! The code is invalid, expired, or already used.</div>
        </div>

        <div class="info-box">
            <h3>Usage Instructions</h3>
            <p>1. Gift codes are used to claim special **bonuses** or rewards.</p>
            <p>2. Each code can only be **used once** per user account.</p>
            <p>3. After successful redemption, the bonus amount will be credited to your **main balance** immediately.</p>
            <p>4. Please contact **Customer Service** if you face any issues while redeeming the code.</p>
        </div>
    </div>

    <div id="successOverlay">
        <div id="bonusAmount">+৳500</div>
    </div>
 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item " aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item active" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>

    <script>
        document.getElementById("bonusForm").addEventListener("submit", function(e){
            e.preventDefault();
            let code = document.getElementById("giftCode").value.trim().toUpperCase();
            
            const failAlert = document.getElementById("failAlert");
            const successOverlay = document.getElementById("successOverlay");

            // Hide previous alerts
            failAlert.style.display = "none";

            // Simple logic for demonstration
            if(code === "PROMO500"){ // The correct code
                
                successOverlay.style.display = "flex";
                document.getElementById("bonusAmount").innerText = "+৳500";
                
                // Confetti/Starburst effect (simplified)
                for(let i=0;i<30;i++){
                    let confetti=document.createElement("div");
                    confetti.className="confetti";
                    confetti.style.left=Math.random()*100+"%";
                    confetti.style.animationDuration=(Math.random()*2+2)+"s";
                    confetti.style.opacity = Math.random();
                    confetti.style.transform = `scale(${Math.random()})`;
                    successOverlay.appendChild(confetti);
                    setTimeout(()=>confetti.remove(),3000);
                }

                // Hide overlay after animation
                setTimeout(()=>{
                    successOverlay.style.display="none";
                    document.getElementById("giftCode").value = ""; // Clear the input field
                },2500);

            } else { // Failed code
                failAlert.style.display = "block";
            }
        });
    </script>
</body>
</html>