<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
  <title>SRT LAB BD</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
  
  <style>
    :root {
      /* Theme Colors */
      --primary-color: #214ebe; /* Strong Blue */
      --primary-gradient: linear-gradient(135deg, #214ebe, #00c7a5); /* Blue-Green Gradient */
      --background: #f0f2f5; /* Light Background */
      --card-bg: #ffffff;
      --text-dark: #222;
      --text-muted: #777;
      --shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
      --button-shadow: 0 8px 20px rgba(33, 78, 190, 0.5);
    }
    
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background: var(--background);
      color: var(--text-dark);
    }
    
    a {
      text-decoration: none;
      color: inherit;
    }

    /* --- Header --- */
    .header {
      background: var(--primary-color);
      color: var(--card-bg);
      padding: 18px 15px;
      text-align: center;
      font-weight: 600;
      font-size: 18px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
      position: sticky;
      top: 0;
      z-index: 100;
      margin-bottom: 20px;
    }
    .back-btn {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: var(--card-bg);
      font-size: 20px;
    }

    /* --- Content & Form --- */
    .content-inner {
      padding: 0 15px;
    }

    .form-card {
      background: var(--card-bg);
      padding: 30px 20px;
      border-radius: 12px;
      box-shadow: var(--shadow);
    }
    
    .input-group {
      margin-bottom: 25px;
    }

    .input-group .label {
      font-size: 14px;
      font-weight: 600;
      color: var(--text-dark);
      margin-bottom: 8px;
      display: block;
    }

    .input-wrapper {
      position: relative;
      display: flex;
      align-items: center;
      border: 1px solid #ddd;
      border-radius: 8px;
      padding: 0 10px;
      background: #fafafa;
      transition: all 0.2s;
    }
    .input-wrapper:focus-within {
      border-color: var(--primary-color);
      box-shadow: 0 0 0 3px rgba(33, 78, 190, 0.1);
    }

    .input-wrapper i {
      font-size: 18px;
      color: var(--text-muted);
      margin-right: 10px;
    }

    .form-input {
      flex-grow: 1;
      border: none;
      height: 48px;
      font-size: 16px;
      color: var(--text-dark);
      background: transparent;
    }
    .form-input:focus {
      outline: none;
    }
    .form-input::placeholder {
        color: #b0b0b0;
    }
    
    /* --- Submit Button --- */
    .submit-btn {
      width: 100%;
      padding: 15px;
      background: var(--primary-gradient);
      border: none;
      border-radius: 10px;
      font-size: 18px;
      font-weight: 700;
      color: var(--card-bg);
      cursor: pointer;
      box-shadow: var(--button-shadow);
      transition: 0.3s;
      letter-spacing: 0.5px;
      margin-top: 15px;
    }
    .submit-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(33, 78, 190, 0.6);
    }
    
    /* --- Service Icon (Optional) --- */
    #service {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 999;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        border-radius: 50%;
    }
  </style>
</head>

<body>
  
  <div class="header">

    Update Password
  </div>
  
  <div class="content-inner">
    <div class="form-card">
      <form action="{{route('user.change.password')}}" method="post" id="passwordForm">
        @csrf
        
        <div class="input-group">
          <label class="label" for="current_password">Current Password</label>
          <div class="input-wrapper">
            <i class="fas fa-lock"></i>
            <input type="password" id="current_password" name="current_password" placeholder="Enter current password" class="form-input" required>
            <i class="fas fa-eye-slash toggle-password" data-target="current_password"></i>
          </div>
        </div>
        
        <div class="input-group">
          <label class="label" for="new_password">New Password</label>
          <div class="input-wrapper">
            <i class="fas fa-key"></i>
            <input type="password" id="new_password" name="new_password" placeholder="Enter new password" class="form-input" required>
            <i class="fas fa-eye-slash toggle-password" data-target="new_password"></i>
          </div>
        </div>
        
        <div class="input-group">
          <label class="label" for="confirm_password">Confirm New Password</label>
          <div class="input-wrapper">
            <i class="fas fa-check-double"></i>
            <input type="password" id="confirm_password" name="confirm_password" placeholder="Confirm new password" class="form-input" required>
            <i class="fas fa-eye-slash toggle-password" data-target="confirm_password"></i>
          </div>
        </div>

        <button type="submit" class="submit-btn" onclick="do_login_password(event)">UPDATE PASSWORD</button>
      </form>
    </div>
  </div>

 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item " aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item active" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>

  @include('alert-message')

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  
  <script>
    // Toggle Password Visibility
    document.querySelectorAll('.toggle-password').forEach(icon => {
        icon.addEventListener('click', function() {
            const targetId = this.getAttribute('data-target');
            const passwordInput = document.getElementById(targetId);
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            // Toggle the eye icon class
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });
    });

    // Custom Validation and Submission Logic
    function message(text) {
        // Replace this with your actual alert/toast function (e.g., from layui or a custom one)
        alert(text); 
    }

    function do_login_password(event) {
        event.preventDefault(); // Prevent default form submission
        
        var old_password = $("#current_password").val().trim();
        var new_password = $("#new_password").val().trim();
        var confirm_password = $("#confirm_password").val().trim();

        if (old_password === "") {
            return message("পুরানো পাসওয়ার্ড লিখুন");
        }

        if (new_password === "") {
            return message("নতুন পাসওয়ার্ড লিখুন");
        }

        if (confirm_password === "") {
            return message("পাসওয়ার্ড নিশ্চিত করুন");
        }

        if (confirm_password !== new_password) {
            return message("পাসওয়ার্ডটি অসামঞ্জস্যপূর্ণ");
        }

        // If all validation passes, submit the form
        document.getElementById('passwordForm').submit();
    }
  </script>

</body>
</html>