<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>SRT LAB BD</title>
<style>
  @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');
  @import url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');

  * {
    box-sizing: border-box;
  }

  body {
    margin: 0;
    font-family: 'Roboto', sans-serif;
    background: #fff;
    color: #000;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  .top-bar {
    display: flex;
    justify-content: space-between;
    padding: 6px 12px 4px;
    font-size: 12px;
    color: #444;
    align-items: center;
    background: #fff;
  }

  .top-bar .left {
    display: flex;
    align-items: center;
    gap: 10px;
  }

  .top-bar .left i {
    font-size: 18px;
    cursor: pointer;
  }

  .top-bar .address {
    background: #f8dada;
    border-radius: 20px;
    padding: 3px 10px;
    font-size: 14px;
    color: #000;
    user-select: text;
  }

  .top-bar .right {
    display: flex;
    align-items: center;
    gap: 15px;
  }

  .top-bar .right i {
    font-size: 18px;
    cursor: pointer;
  }

  .top-bar .right .notification-badge {
    position: relative;
    font-size: 16px;
  }

  .top-bar .right .notification-badge::after {
    content: '5';
    position: absolute;
    top: -7px;
    right: -10px;
    background: #000;
    color: #fff;
    font-size: 10px;
    font-weight: 600;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    line-height: 16px;
    text-align: center;
  }

  .balance-card {
    margin: 10px 10px 15px;
    border-radius: 15px;
    background: url('https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=800&q=80') no-repeat center center/cover;
    color: white;
    padding: 30px 20px 25px;
    text-align: center;
    position: relative;
    overflow: hidden;
    box-shadow: 0 2px 10px rgb(0 0 0 / 0.15);
  }

  .balance-card::before {
    content: '';
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.3);
    border-radius: 15px;
    z-index: 0;
  }

  .balance-card * {
    position: relative;
    z-index: 1;
  }

  .balance-card .title {
    font-size: 16px;
    margin-bottom: 10px;
    font-weight: 400;
  }

  .balance-card .balance-amount {
    font-size: 40px;
    color: #ffb300;
    font-weight: 600;
    margin-bottom: 25px;
  }

  .balance-info {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 50px;
    font-weight: 400;
    font-size: 14px;
  }

  .balance-info .item {
    display: flex;
    flex-direction: column;
  }

  .balance-info .value {
    font-size: 25px;
    font-weight: 700;
  }

  .divider-vertical {
    width: 1px;
    height: 35px;
    background: white;
    opacity: 0.7;
    margin: 0 15px;
  }

  .balance-actions {
    margin: 20px 10px 25px;
    display: flex;
    gap: 10px;
  }

  .balance-actions button {
    flex: 1;
    background: #ff6fb5;
    border: none;
    border-radius: 10px;
    color: white;
    font-size: 16px;
    padding: 12px 0;
    cursor: pointer;
    font-weight: 500;
  }

  .options-grid {
    margin: 0 10px 40px;
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 12px;
  }

  .option-card {
    background: #fafafa;
    border-radius: 12px;
    padding: 15px 10px;
    box-shadow: 0 0 10px rgb(0 0 0 / 0.03);
    display: flex;
    gap: 8px;
    align-items: center;
    font-weight: 500;
    font-size: 14px;
    cursor: pointer;
    color: #214ebe;
    text-decoration: none;
  }

  .option-card i {
    font-size: 24px;
    flex-shrink: 0;
  }

  .option-card.lock i.fa-lock {
    font-size: 20px;
  }

  .option-card.exit i {
    color: #de3b24;
  }

  .bottom-menu {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f9f9f9;
    border-top: 1px solid #ddd;
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 6px 0;
    font-size: 11px;
    color: #ec749f;
    font-weight: 600;
    user-select: none;
  }

  .bottom-menu div {
    flex-grow: 1;
    text-align: center;
    cursor: pointer;
    display: flex;
    flex-direction: column;
    color: #ec749f;
    text-decoration: none;
  }

  .bottom-menu div i {
    font-size: 22px;
    margin-bottom: 2px;
  }

  .bottom-menu div.inactive {
    color: #c7b2b4;
  }

  .bottom-menu div.active {
    color: #ec749f;
  }

  a {
    text-decoration: none;
    color: inherit;
  }

</style>
</head>
<body>

<!-- Balance card -->
<div class="balance-card" role="region" aria-label="Account Balance">
  <div class="title">Account balance</div>
  <div class="balance-amount">{{ number_format(auth()->user()->balance, 2) }}</div>
  <div class="balance-info">
    <div class="item">
      <div>Total team</div>
      <div class="value">0</div>
    </div>
    <div class="divider-vertical" aria-hidden="true"></div>
    <div class="item">
      <div>Total withdrawn</div>
      <div class="value">{{ number_format($totalWithdraw, 2) }}</div>
    </div>
  </div>
</div>

<div class="balance-actions">
  <a href="/user/recharge" class="balance-btn">Top-up</a>
  <a href="/withdraw" class="balance-btn">Cash out</a>
</div>

<style>
.balance-actions {
  display: flex;
  gap: 10px;
  justify-content: center;
  margin-top: 10px;
}

.balance-actions .balance-btn {
  flex: 1;
  background: #214ebe;
  border: none;
  border-radius: 10px;
  color: white;
  font-size: 16px;
  padding: 12px 0;
  cursor: pointer;
  font-weight: 500;
  text-align: center;
  text-decoration: none;
  transition: 0.3s;
}

.balance-actions .balance-btn:nth-child(2) {
  background: #214ebe; /* দ্বিতীয় বাটনের রঙ একটু আলাদা */
}

.balance-actions .balance-btn:hover {
  opacity: 0.9;
  transform: scale(1.03);
}
</style>


<!-- Options -->
<div class="options-grid" role="list">
  <a href="my/password">
    <div class="option-card lock" role="listitem" tabindex="0" aria-label="Change login password">
      <i class="fa fa-lock" aria-hidden="true"></i>
      <span>CHANGE PASSWORD</span>
    </div>
  </a>
  
    <a href="/history">
    <div class="option-card" role="listitem" tabindex="0" aria-label="Balance record">
      <i class="fa fa-clipboard" aria-hidden="true"></i>
      <span>BALANCE RECORD</span>
    </div>
  </a>
  
  
  <a href="add/card">
    <div class="option-card" role="listitem" tabindex="0" aria-label="Add bank card">
      <i class="fa fa-credit-card" aria-hidden="true"></i>
      <span>ADD BANK CARD</span>
    </div>
  </a>
  
<a href="/invite">
  <div class="option-card" role="listitem" tabindex="0" aria-label="My Team">
    <i class="fa fa-user" aria-hidden="true"></i>
    <span>INVITE</span>
  </div>
</a>

  <a href="/my-team">
  <div class="option-card" role="listitem" tabindex="0" aria-label="My Team">
    <i class="fa fa-users" aria-hidden="true"></i>
    <span>MY TEAM</span>
  </div>
</a>

 <a href="/promo">
  <div class="option-card" role="listitem" tabindex="0" aria-label="My Gift">
    <i class="fa-solid fa-gift" aria-hidden="true"></i>
    <span>GIFT CODE</span>
  </div>
</a>





  <a href="https://t.me/EarningSourceLAB">
    <div class="option-card" role="listitem" tabindex="0" aria-label="Balance record">
      <i class="fa-solid fa-phone" aria-hidden="true"></i>
      <span>SERVICE</span>
    </div>
  </a>

<a href="/logout">
  <div class="option-card exit" role="listitem" tabindex="0" aria-label="Logout">
    <i class="fa-solid fa-arrow-right-from-bracket" aria-hidden="true"></i>
    <span>LOGOUT</span>
  </div>
</a>

</div>
 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item " aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item active" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>
