<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
  <title>SRT LAB BD</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
  <style>
    :root{
      /* Custom Color: #214ebe (Blue-Green) */
      --primary-color: #214ebe;
      --primary-gradient: linear-gradient(135deg, #214ebe, #00c7a5);
      --background: #f0f2f5;
      --card-bg:#ffffff;
      --text-dark:#222;
      --text-muted:#666;
      /* Adjusted Shadow for the new color theme */
      --shadow: 0 6px 18px rgba(33, 78, 190, 0.25), 0 0 14px rgba(0, 199, 165, 0.35);
      --button-shadow: 0 6px 15px rgba(33, 78, 190, 0.5);
    }
    *{margin:0;padding:0;box-sizing:border-box;-webkit-tap-highlight-color:transparent;user-select:none}
    body{font-family:'Poppins',sans-serif;background:var(--background);color:var(--text-dark);padding-bottom:85px}

    /* --- NEW HEADER STYLE (My Team style) --- */
    .header{
      background:var(--primary-color);
      padding:15px;text-align:center;color:var(--card-bg);
      font-weight:600;font-size:18px;
      box-shadow:var(--shadow);
      position:sticky; top:0; z-index:100;
    }
    .back-btn{position:absolute;left:15px;top:15px;color:var(--card-bg);text-decoration:none;font-size:20px}
    /* --- END HEADER STYLE --- */

    .hero{padding:28px 18px 16px 18px;text-align:center}
    .hero .title{font-size:24px;font-weight:700;letter-spacing:.5px;
      color:var(--text-dark);margin-bottom:5px;
    }
    .hero .subtitle{font-size:14px;color:var(--text-muted)}

    /* Card Section */
    .card{margin:15px;padding:20px;background:var(--card-bg);border-radius:18px;box-shadow:var(--shadow)}
    .section-title{text-align:center;font-size:18px;font-weight:700;margin-bottom:15px;color:var(--primary-color)}

    /* Row Styling */
    .row{display:flex;align-items:center;margin:15px 0;padding:12px 0;border-bottom:1px solid #eee;}
    .row:last-child{border-bottom:none;}
    .label{flex:0 0 100px;font-size:14px;color:var(--text-muted);font-weight:500;}
    .value{flex:1;font-size:16px;font-weight:600;color:var(--text-dark);word-break:break-all}
    .value.code{font-size:24px;font-weight:800;color:var(--primary-color);}
    
    /* Copy Button */
    .copy-btn{border:none;cursor:pointer;font-weight:600;color:var(--card-bg);
      padding:8px 14px;border-radius:12px;box-shadow:var(--button-shadow);
      background:var(--primary-gradient);transition:.2s;flex-shrink:0;
      font-size:13px;
    }
    .copy-btn:hover{transform:translateY(-1px) scale(1.03)}
    
    .divider{height:1px;background:#efefef;margin:14px 0}
    
    /* Info Sections */
    .info{margin:0 15px 15px;padding:18px;border-radius:18px;background:var(--card-bg);box-shadow:var(--shadow)}
    .info h4{font-size:16px;font-weight:700;margin-bottom:10px;color:var(--primary-color)}
    .info p,.info li{font-size:13px;color:#333;line-height:1.7}
    .info ul{padding-left:18px;list-style:disc inside;}

    /* Toast Notification */
    #toast{display:none;position:fixed;top:20px;left:50%;transform:translateX(-50%);
      background:var(--primary-color);color:var(--card-bg);padding:10px 18px;border-radius:10px;font-weight:700;
      box-shadow:0 8px 18px rgba(0,0,0,.2);z-index:9999;opacity:0;transition:opacity .25s}
    #toast.show{display:block;opacity:1}

    /* Bottom Menubar (My Team style) */
    .menubar{position:fixed;bottom:0;left:0;right:0;height:70px;background:var(--card-bg);
      box-shadow:0 -4px 15px rgba(0,0,0,.1);display:flex;justify-content:space-around;
      align-items:center;z-index:999;border-radius:16px 16px 0 0}
    .nav-link{display:flex;flex-direction:column;align-items:center;font-size:12px;text-decoration:none;color:#777;padding:5px 0;}
    .nav-link i{font-size:20px;margin-bottom:4px}
    .nav-link.active{color:var(--primary-color);font-weight:700;text-shadow:0 0 8px rgba(33, 78, 190, 0.3);}
    .zoom-btn{position:relative;top:-25px;width:65px;height:65px;background:var(--primary-gradient);
      border-radius:50%;display:flex;align-items:center;justify-content:center;box-shadow:var(--button-shadow);border:4px solid var(--background)}
    .zoom-btn i{color:var(--card-bg);font-size:24px}
  </style>
</head>
<body>

  <div class="header">

    Invite Friends
  </div>

  <div class="hero">
    <div class="title"> Invite & Earn</div>
    <div class="subtitle"></div>
  </div>

  <div class="card">
    <div class="section-title">My Invitation Details</div>
    
    <div class="row">
      <div class="label">Code:</div>
      <div class="value code" id="codeText">{{ auth()->user()->ref_id ?? '9610911' }}</div>
      <button class="copy-btn" onclick="copyToClipboard(document.getElementById('codeText').innerText)">COPY</button>
    </div>
    
    <div class="row">
      <div class="label">Link:</div>
      <div class="value" id="linkText">{{ url('register').'?inviteCode='.(auth()->user()->ref_id ?? '9610911') }}</div>
      <button class="copy-btn" onclick="copyToClipboard(document.getElementById('linkText').innerText)">COPY</button>
    </div>
    
  </div>

  <div class="info">
    <h4><i class="fa-solid fa-coins"></i> Commission Structure</h4>
    <p>Level 1: <b>28%</b>, Level 2: <b>2%</b>, Level 3: <b>1%</b>. Packages start from <b>৳150</b>.</p>
  </div>
  

<!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item " aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item active" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item " aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>
  <script>
    const inviteLink = "{{ url('register').'?inviteCode='.(auth()->user()->ref_id ?? '9610911') }}";
    
    function showToast(msg){
      const t=document.getElementById('toast');
      t.innerText=msg;t.classList.add('show');
      setTimeout(()=>t.classList.remove('show'),2500);
    }
    function copyToClipboard(text){
      navigator.clipboard.writeText(text).then(()=>showToast('✅ Copied Successfully')).catch(()=>showToast('❌ Failed to Copy'));
    }
    /* Removed shareTelegram() and shareWhatsApp() as per request */
  </script>
</body>
</html>