<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Earning Source Lab</title>
<style>
  /* Reset & base */
  * {
    box-sizing: border-box;
  }
  body {
    margin:0;
    font-family: Arial, sans-serif;
    background: #f0f0f0;
    color: #0a1a4a;
  }
  img {
    max-width: 100%;
    display: block;
  }
  button {
    cursor: pointer;
    border: none;
    outline: none;
  }

  /* Container */
  .container {
    max-width: 420px;
    margin: auto;
    background: #ededed;
    border-radius:12px;
    overflow: hidden;
  }

  /* Header image area */
  .header-image {
    position: relative;
    width: 100%;
    border-radius: 12px 12px 0 0;
    overflow: hidden;
  }
  .header-image img {
    width: 100%;
    display: block;
    border-radius: 12px 12px 0 0;
  }

  /* Action buttons row */
  .actions {
    display: flex;
    justify-content: space-between;
    padding: 15px 15px 10px;
    gap: 12px;
  }
.action-btn {
  background-color: #214ebe;
  flex: 1;
  color: white;
  font-size: 14px;
  border-radius: 12px;
  padding: 15px 0;
  text-align: center;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 6px;
  box-shadow: 0 2px 5px rgb(0 0 0 / 0.15);

  text-decoration: none; /* <- underline বন্ধ করার জন্য */
}

  .action-btn svg {
    width: 32px;
    height: 32px;
    stroke: white;
    stroke-width: 1.8;
    fill: none;
  }

  /* Tabs for Daily income and Activity plan */
  .tabs {
    display: flex;
    border-radius: 12px;
    background: white;
    margin: 12px 15px;
    overflow: hidden;
  }
  .tab {
    flex: 1;
    padding: 12px 0;
    font-weight: 700;
    text-align: center;
    cursor: pointer;
    color: #214ebe;
  }
  .tab {
  cursor: pointer;
    padding: 12px 0;
  display: inline-block;
  text-decoration: none; /* <- underline off */
}

  .tab.active {
    background: #214ebe;
    color: white;
  }

  /* Product card */
  .product-card {
    background: white;
    margin: 12px 15px;
    border-radius: 12px;
    overflow: hidden;
    display: flex;
    gap: 12px;
    box-shadow: 0 2px 5px rgb(0 0 0 / 0.1);
    padding: 12px;
  }
  .product-image {
    width: 120px;
    position: relative;
  }
  .quota-label {
    position: absolute;
    top: 8px;
    left: 0;
    background: white;
    color: #214ebe;
    font-size: 12px;
    font-weight: 600;
    padding: 3px 8px;
    border-radius: 15px 12px 12px 15px;
    box-shadow: 0 0 8px #214ebe33;
  }
  .product-image img {
    border-radius: 12px;
  }

  .product-info {
    flex: 1;
    padding: 4px 0;
    display: flex;
    flex-direction: column;
    justify-content: start;
  }
  .product-info h3 {
    margin: 0 0 6px 0;
    font-weight: 700;
    font-size: 18px;
  }
  .price {
    color: #214ebe;
    font-weight: 700;
    font-size: 20px;
    margin-bottom: 6px;
  }
  .profit-row {
    font-size: 14px;
    padding: 4px 10px;
    margin-bottom: 6px;
    background: #ebf0ff;
    border-radius: 12px;
    color: #214ebe;
    font-weight: 600;
    width: fit-content;
  }
  .buy-btn {
    background: #214ebe;
    color: white;
    border-radius: 12px;
    padding: 12px 0;
    text-align: center;
    font-weight: 600;
    margin-top: auto;
    cursor: pointer;
    box-shadow: 0 3px 8px rgb(33 78 190 / 0.7);
  }
  .buy-btn:hover {
    background: #1a3eae;
  }

  /* Bottom nav */
  .bottom-nav {
    background: white;
    padding: 6px 0;
    display: flex;
    justify-content: space-around;
    border-top: 1px solid #ddd;
    position: sticky;
    bottom: 0;
  }
  .nav-item {
    font-size: 11px;
    color: #214ebe;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 2px;
    flex: 1;
    padding: 6px 0;
  }
  .nav-item svg {
    width: 22px;
    height: 22px;
    stroke: #214ebe;
    stroke-width: 1.7;
    fill: none;
  }
  .nav-item.active {
    font-weight: 600;
    color: #214ebe;
  }

</style>
</head>
<body>
  <div class="container">
    <!-- Header Image -->
    <div class="header-image">
      <img src="/srtlabbd/apple-1200x675.webp" alt="Pillsbury banner" />
    </div>

    <!-- Action Buttons -->
<!-- Action Buttons -->
<div class="actions">
  <a href="/user/recharge" class="action-btn" aria-label="Recharge">
    <!-- Card with plus icon -->
    <svg viewBox="0 0 24 24"><rect x="2" y="7" width="20" height="10" rx="2" ry="2" /><line x1="12" y1="10" x2="12" y2="14"/><line x1="10" y1="12" x2="14" y2="12"/></svg>
    Recharge
  </a>

  <a href="/withdraw" class="action-btn" aria-label="Withdraw">
    <!-- Card icon -->
    <svg viewBox="0 0 24 24"><rect x="2" y="7" width="20" height="10" rx="2" ry="2" /></svg>
    Withdraw
  </a>

  <a href="/service" class="action-btn" aria-label="Service">
    <!-- 24 hour icon -->
    <svg viewBox="0 0 24 24"><circle cx="12" cy="12" r="9" /><polyline points="12 7 12 12 15 14" /><text x="7" y="18" font-size="8" fill="#fff" font-weight="bold">24h</text></svg>
    Service
  </a>

  <a href="https://t.me/EarningSourceLAB" class="action-btn" aria-label="Channel">
    <!-- Paper plane icon -->
    <svg viewBox="0 0 24 24"><line x1="22" y1="2" x2="11" y2="13"/><polygon points="22 2 15 22 11 13 2 9 22 2"/></svg>
    Channel
  </a>
</div>

    <!-- Tabs -->
    <div class="tabs">
      <div class="tab active">Daily income</div>
 <a href="/my/vip" class="tab" data-tab="activity">Activity Plan</a>
    </div>

<?php
use \App\Models\Package;
use \App\Models\Purchase;
use Illuminate\Support\Facades\Auth;

$dailyPlans = Package::where('Status','!=','inactive')->where('tab','vip')->get();
$user = Auth::user();
?>

<!-- Daily Product Cards -->
<div class="daily-product-cards">
  @foreach($dailyPlans as $element)
    <?php
      $myVip = $user ? Purchase::where('user_id', $user->id)
                          ->where('package_id', $element->id)
                          ->where('status','active')
                          ->first() : null;
      $balance = $user ? ($user->balance ?? 0) : 0;
    ?>
    <div class="product-card">
      <div class="product-image">
        <span class="quota-label">Quota {{ $myVip ? 1 : 0 }}/{{ $element->quota ?? 2 }}</span>
        <img src="{{ asset($element->photo) }}" alt="{{ $element->name }}" />
      </div>
      <div class="product-info">
        <h3>{{ $element->name }}</h3>
        <div class="price"> {{ price($element->price) }}</div>
        <div class="profit-row">Daily profit :  {{ price($element->daily_limit) }}</div>
<div class="profit-row">Day : {{ $element->validity }}</div>
<div class="profit-row">Total profit : {{ price(($element->daily_limit ?? 0) * ($element->validity ?? 0)) }}</div>


        @if($myVip)
          <button class="buy-btn" disabled>🛒 Already Purchased</button>
        @elseif($balance >= $element->price)
          <button class="buy-btn" onclick="window.location.href='/purchase/confirmation/{{ $element->id }}'">🛒 Buy now</button>
        @else
          <button class="buy-btn" onclick="alert('⚠️ Insufficient balance! Please top-up.')">🛒 Top-up</button>
        @endif
      </div>
    </div>
  @endforeach
</div>

<br>
<br>
<br>

<br>
   <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item active" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>
