<!DOCTYPE html>
<html lang="bn">

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">

    <link rel="shortcut icon" type="image/x-icon" href="/IMG_20250918_172903_494.jpg">
    <title>SRT LAB BD</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    
</head>

<body>
<div class="page-wraper">

<style>
    /* --- Color Palette (Deep Blue & White - Replaced Orange/Pink) --- */
    :root {
        /* Deep Blue Gradient for Header/Primary Accent */
        --theme-gradient: linear-gradient(135deg, #214ebe, #214ebe); 
        --theme-primary: #214ebe; /* Deep Blue */
        --theme-light: #52a3ff; /* Lighter Blue */
        --text-light: #ffffff;
        --text-dark: #333333;
        --background-color: #f7f8fa; /* Light background */
        --card-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        --success-color: #27ae60;
        --pending-color: #f39c12;
        --failed-color: #e74c3c;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Poppins', sans-serif;
        background-color: var(--background-color); 
    }

    .page-wraper {
        background-color: transparent;
    }
    
    .container {
        padding: 0 15px;
    }

    /* Header Design */
    .header {
        background: var(--theme-gradient); /* Applied Deep Blue Gradient */
        padding: 15px;
        display: flex;
        align-items: center;
        color: var(--text-light);
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .header .main-bar, .header .header-content {
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .header .back-btn {
        color: var(--text-light);
        font-size: 20px;
        text-decoration: none;
    }
    .header .mid-content {
        flex-grow: 1;
        text-align: center;
    }
    .header .mb-0 {
        color: var(--text-light);
        font-weight: 600;
        font-size: 18px;
        margin: 0;
    }

    .history-container {
        padding: 20px 15px;
    }

    /* Transaction Card Design */
    .transaction-card {
        background: white;
        border-radius: 15px;
        box-shadow: var(--card-shadow);
        margin-bottom: 15px;
        overflow: hidden;
        transition: transform 0.3s ease;
    }
    .transaction-card:hover {
        transform: translateY(-3px);
    }
    .card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 15px;
        background: #f2f6ff; /* Very Light Blue/White Background for Header */
        border-bottom: 1px solid #f0f0f0;
    }
    .transaction-reason {
        font-weight: 600;
        color: var(--text-dark);
        font-size: 14px;
    }
    .transaction-date {
        font-size: 12px;
        color: #888;
    }
    .card-body {
        padding: 15px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .amount {
        font-size: 20px;
        font-weight: 700;
        color: var(--theme-primary); /* Applied Deep Blue */
    }
    .status {
        padding: 5px 12px;
        border-radius: 50px;
        font-size: 12px;
        font-weight: 500;
        text-transform: capitalize;
    }
    /* Status Colors remain the same for consistency (Green/Yellow/Red) */
    .status-approved {
        background-color: rgba(39, 174, 96, 0.1);
        color: var(--success-color);
    }
    .status-pending {
        background-color: rgba(243, 156, 18, 0.1);
        color: var(--pending-color);
    }
    .status-rejected {
        background-color: rgba(231, 76, 60, 0.1);
        color: var(--failed-color);
    }
    
    .no-transactions {
        text-align: center;
        padding: 40px;
        margin-top: 20px;
        background: white;
        border-radius: 15px;
        box-shadow: var(--card-shadow);
        color: #888;
    }
</style>


<header class="header">
    <div class="main-bar">
        <div class="container">
            <div class="header-content">

                <div class="mid-content">
                    <h5 class="mb-0">History</h5>
                </div>
                <div style="width: 20px;"></div> </div>
        </div>
    </div>
</header>

<div class="history-container">
    @if(\App\Models\UserLedger::where('user_id', auth()->id())->count() > 0)
        @foreach(\App\Models\UserLedger::where('user_id', auth()->id())->orderByDesc('id')->get() as $element)
        <div class="transaction-card">
            <div class="card-header">
                <div class="transaction-reason">{{ $element->reason }}</div>
                <div class="transaction-date">{{ $element->created_at->format('d M, Y h:i A') }}</div>
            </div>
            <div class="card-body">
                <div class="amount">{{ price($element->amount) }}</div>
                <div class="status status-{{ strtolower($element->status) }}">
                    {{ $element->status }}
                </div>
            </div>
        </div>
        @endforeach
    @else
        <div class="no-transactions">
            <p>No transactions found.</p>
        </div>
    @endif
</div>


<script src="/assets/app/js/jquery.js"></script>
<script src="/assets/app/js/custom.js?v=45"></script>

</body>
</html>