<!DOCTYPE html>
<html lang="bn">

<head>

  <!-- Meta -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">

  <!-- Favicons Icon -->
  <link rel="shortcut icon" type="image/x-icon" href="/IMG_20250918_172903_494.jpg">
  <!-- Title -->
  <title>About Us</title>

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  
</head>

<body>
<div class="page-wraper">

<style>
    :root {
        --theme-gradient: linear-gradient(135deg, #FFB74D, #FF9100);
        --theme-primary: #FF9100;
        --text-light: #ffffff;
        --text-dark: #333333;
        --background-color: #f7f8fa;
        --card-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Poppins', sans-serif;
        color: var(--text-dark);
        background-color: var(--background-color);
    }

    .page-wraper {
        background-color: transparent;
        padding-bottom: 20px;
    }
    
    .container {
        padding: 0 15px;
    }

    /* Header Design */
    .header {
        background: var(--theme-gradient);
        padding: 15px;
        display: flex;
        align-items: center;
        color: var(--text-light);
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .header .main-bar, .header .header-content {
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .header .back-btn {
        color: var(--text-light);
        font-size: 20px;
        text-decoration: none;
    }
    .header .mid-content {
        flex-grow: 1;
        text-align: center;
    }
    .header .mb-0 {
        color: var(--text-light);
        font-weight: 600;
        font-size: 18px;
        margin: 0;
    }

    /* About Content Card */
    .about-container {
        background: white;
        border-radius: 20px;
        padding: 25px;
        margin: 20px 15px;
        box-shadow: var(--card-shadow);
    }

    .main-image {
        width: 100%;
        border-radius: 15px;
        margin-bottom: 25px;
    }

    .title {
        font-size: 24px;
        font-weight: 700;
        color: var(--text-dark);
        text-align: center;
        margin-bottom: 20px;
    }

    .text {
        font-size: 14px;
        line-height: 1.8;
        color: #555;
        margin-bottom: 20px;
        text-align: justify;
    }

    .section-heading {
        font-size: 18px;
        font-weight: 600;
        color: var(--theme-primary);
        margin-top: 25px;
        margin-bottom: 10px;
        padding-bottom: 5px;
        border-bottom: 2px solid #ffeacc;
    }

    .meta {
        font-size: 13px;
        font-weight: 600;
        color: #888;
        margin-bottom: 8px;
    }
    
    .highlight {
        background: #fff7ee;
        border-left: 4px solid var(--theme-primary);
        padding: 15px;
        margin: 25px 0;
        border-radius: 0 8px 8px 0;
    }
    .highlight p {
        margin: 0;
        color: #555;
        font-style: italic;
        font-weight: 500;
    }
</style>


<!-- Header -->
<header class="header">
  <div class="main-bar">
    <div class="container">
      <div class="header-content">
        <a href="javascript:history.back()" class="back-btn"><i class="fas fa-chevron-left"></i></a>
        <div class="mid-content">
          <h5 class="mb-0">About Us</h5>
        </div>
        <div style="width: 20px;"></div> <!-- Spacer -->
      </div>
    </div>
  </div>
</header>

<div class="page-wraper">
    <div class="about-container">
      <img src="/resources/views/app/main/IMG_20250918_172854_134.jpg" alt="{{ env('APP_NAME') }} office and team" class="main-image">

      <h1 class="title">{{ env('APP_NAME') }}</h1>

      <p class="text">{{ env('APP_NAME') }} AI builds practical AI products that help businesses understand data faster and make smarter decisions. Our platform blends state‑of‑the‑art models with a clean developer workflow, so teams can go from idea to production without the usual friction. We focus on privacy, reliability, and real outcomes, not hype.</p>

      <div class="meta">Founded • 2023</div>
      <h2 class="section-heading">Our Mission</h2>
      <p class="text">Make advanced AI usable for everyone. We design tools that feel simple, respect user data, and scale from side projects to the enterprise. If it doesn’t make your day easier, we don’t ship it.</p>

      <div class="highlight">
        <p>“Great AI should disappear into your workflow and let your work shine.” — TEAM {{ env('APP_NAME') }}</p>
      </div>

      <h2 class="section-heading">What We Do</h2>
      <p class="text"><strong>Data to Decisions:</strong> Ingest documents, chats, and logs, then query them safely with guardrails. <strong>Automation:</strong> Trigger actions across your stack using natural language and typed functions. <strong>Trust:</strong> Transparent evaluations, versioned prompts, and audit logs out of the box.</p>

      <h2 class="section-heading">Recent Highlights</h2>
      <div class="meta">August 2025</div>
      <p class="text">Shipped {{ env('APP_NAME') }} Workflows with human‑in‑the‑loop review and SOC 2 friendly logging.</p>
      <div class="meta">June 2025</div>
      <p class="text">Opened our Bangalore office and launched a free developer tier.</p>
      <div class="meta">April 2025</div>
      <p class="text">Released typed function calling SDKs for PHP, Node, and Python.</p>

      <h2 class="section-heading">Contact</h2>
      <p class="text">Want a demo or to explore partnerships? Reach out via the contact form or say hello on Telegram from the homepage. We usually reply within one business day.</p>
    </div>
</div>

<!-- Scripts -->
<script src="/assets/app/js/jquery.js"></script>
<script src="/assets/app/js/custom.js?v=45"></script>

</body>
</html>